/*
 * Decompiled with CFR 0.152.
 */
package my.QMX;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class qmxUI
extends JFrame {
    static final boolean DEBUG_MODE = false;
    static final int FRAME_WIDTH_DELTA = -95;
    SerialPort qmxPort;
    OutputStream txStream;
    static boolean enableLog = false;
    static boolean verboseLogTuning = false;
    static boolean contactLog = false;
    static final int BOTTOM_ROW_VDELTA = -5;
    static final int DEBUG_AREA_VDELTA = -10;
    static final int BELOW_BAND_ROW_VDELTA = 30;
    static final int LOG_TEXT_WIDTH = 140;
    static final int BAUD = 9600;
    int DATABITS = 8;
    int STOPBITS = 1;
    int NO_PARITY = 0;
    static final int VCOLS = 10;
    static final int VFOA_HPOS = 50;
    static final int VFOA_VPOS = 15;
    static final int VFOB_HPOS = 50;
    static final int VFOB_VPOS = 65;
    JTextField[] vfoA = new JTextField[10];
    JTextField[] vfoB = new JTextField[10];
    static final String DLM = ".";
    String lastVFOA = "00000000000";
    String lastVFOB = "00000000000";
    static final int LB20 = 14000;
    static final int UB20 = 14350;
    static final int LB17 = 18068;
    static final int UB17 = 18168;
    static final int LB15 = 21000;
    static final int UB15 = 21450;
    static final int LB12 = 24890;
    static final int UB12 = 24990;
    static final int LB10 = 28000;
    static final int UB10 = 29700;
    static final int BBTN_HPOS = 50;
    static final int BBTN_HDELTA = 15;
    static final int BBTN_VPOS = 115;
    String bS20A = "00014074000";
    String bS17A = "00018104600";
    String bS15A = "00021094600";
    String bS12A = "00024924600";
    String bS11A = "00027245000";
    String bS10A = "00028124600";
    String bS20B = "00014074000";
    String bS17B = "00018104600";
    String bS15B = "00021094600";
    String bS12B = "00024924600";
    String bS11B = "00027245000";
    String bS10B = "00028124600";
    int rxVFO = 0;
    int txVFO = 0;
    boolean splitVFO = false;
    int targetVFO = 0;
    int slowHz = 10;
    int fastHz = 500;
    Color tuneableVFOlabelColor = new Color(255, 255, 128);
    static final int NBANDS = 6;
    int[] bandDefaultFrequency = new int[]{14074, 18104, 21094, 24924, 27245, 28124};
    int currentBandNdx = -1;
    int previousBandNdx = -1;
    static final int CAT_UPDATE_INTERVAL = 120;
    static final char EOC = ';';
    static final char UNK = '?';
    String sCommand = "";
    String sendOnce = "";
    String sendAlways = "FA;MD;TQ;";
    int catMsgNdx = 0;
    int catMsgCount = 4;
    String[] catMsgList = new String[]{"FA;", "FB;", "MD;TQ;", "FR;FT;SP;"};
    boolean ritStatus = false;
    String sRIT = "";
    char cOperMode;
    int xcvrStatus = 0;
    int operMode = 0;
    int rcvVFO = 0;
    boolean simplex = true;
    boolean TxMode = false;
    static final int RLBLS_HDELTA = 12;
    static final int BANDLBL_VDELTA = 4;
    static final int MODELBL_VDELTA = 24;
    boolean logActive = false;
    static final char TAB = '\t';
    static final char SP = ' ';
    String logFilePath = "./";
    String logFileName = "qmxLog.txt";
    FileWriter logFileWriter;
    BufferedWriter logFileBufferedWriter;
    boolean lastLoggedSplitVFO = false;
    boolean lastLoggedTxMode = false;
    LocalDateTime logDT;
    LocalDateTime lastLogDT;
    LocalDateTime lastRxTxTransitionDT;
    LocalDateTime lastLoggedFreqDT;
    private final int TxRxTransitionDuration = 5;
    private final int MIN_VFO_LOG_INTERVAL = 1;
    char lastOperMode = (char)48;
    int lastRxVFO = -1;
    boolean rigctlEnabled = false;
    String rigctlHost = "localhost";
    int rigctlPort = 4532;
    OutputStream rcOutput;
    PrintWriter rcWriter;
    InputStream rcInput;
    BufferedReader rcReader;
    int rigctlVFO = -1;
    int freqCorrection = 0;
    int rigctlMod = 5;
    private final int LOG_BTN_TO_RIGCTL_BTN_Y_DELTA = 27;
    boolean debugFileEnabled = true;
    String debugFilePath = "./";
    String debugFileName = "debugLog.txt";
    public static FileWriter debugFileWriter;
    PrintWriter debugPrint;
    boolean debugOnce = true;
    private final int MAX_DEBUG_PRINTS = 5;
    int debugPrintCount = 0;
    public Timer CAT_update_timer = new Timer(120 / this.catMsgCount, e -> {
        this.sendCAT(this.catMsgList[this.catMsgNdx++ % this.catMsgCount]);
        if (this.sendOnce.length() > 0) {
            this.sendCAT(this.sendOnce);
            this.sendOnce = "";
        }
        if (this.rigctlEnabled && this.catMsgNdx % this.rigctlMod == 0) {
            String sTmp = this.newGetRigctlFrequency();
            this.processFrequencyFromRigctl(sTmp);
        }
    });
    private ButtonGroup BandBtnGroup;
    private JTextField TxIndicatorTextField;
    private JLabel bandLbl;
    private JLabel comPortLbl;
    private JComboBox<String> comSelectComboBox;
    private JButton connectBtn;
    private JTextArea debugData;
    private JButton disconnectBtn;
    private JButton dnBtn;
    private JTextField jLogTextField;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton logBtn;
    private JPanel mainInterfacePanel;
    private JLabel modeLbl;
    private JTextField prototypeTextField;
    private JButton prototypeUpDnBtn;
    private JRadioButton rBtn10;
    private JRadioButton rBtn12;
    private JRadioButton rBtn15;
    private JRadioButton rBtn17;
    private JRadioButton rBtn20;
    private JButton sdr2qmxBtn;
    private JButton setTimeBtn;
    private JLabel splitLbl;
    private JButton testButton;
    private JCheckBox tuningRateCheckBox;
    private JButton upBtn;
    private JLabel vfoALbl;
    private JLabel vfoBLbl;

    public qmxUI() {
        this.setLocationRelativeTo(null);
        this.initComponents();
        this.setBounds(this.getX(), this.getY(), this.getWidth() + -95, this.getHeight());
        boolean debugStatus = false;
        this.debugData.setEnabled(false);
        this.debugData.setEditable(false);
        this.debugData.setVisible(false);
        this.prototypeTextField.setVisible(false);
        this.prototypeUpDnBtn.setVisible(false);
        this.connectBtn.setEnabled(true);
        this.disconnectBtn.setEnabled(false);
        this.mainInterfacePanel.setLayout(null);
        for (int i = 0; i < 10; ++i) {
            this.vfoA[i] = new JTextField("");
            this.vfoB[i] = new JTextField("");
            this.mainInterfacePanel.add(this.vfoA[i]);
            this.mainInterfacePanel.add(this.vfoB[i]);
            this.vfoA[i].setBackground(this.prototypeTextField.getBackground());
            this.vfoB[i].setBackground(this.prototypeTextField.getBackground());
            this.vfoA[i].setForeground(this.prototypeTextField.getForeground());
            this.vfoB[i].setForeground(this.prototypeTextField.getForeground());
            this.vfoA[i].setSize(this.prototypeTextField.getSize());
            this.vfoB[i].setSize(this.prototypeTextField.getSize());
            this.vfoA[i].setLocation(i * this.prototypeTextField.getWidth() + 50, 15);
            this.vfoB[i].setLocation(i * this.prototypeTextField.getWidth() + 50, 65);
            this.vfoA[i].enableInputMethods(true);
            this.vfoB[i].enableInputMethods(true);
            this.vfoA[i].setText("");
            this.vfoB[i].setText("");
            this.vfoA[i].setFont(this.prototypeTextField.getFont());
            this.vfoB[i].setFont(this.prototypeTextField.getFont());
            this.vfoA[i].setEditable(false);
            this.vfoB[i].setEditable(false);
            this.vfoA[i].setVisible(true);
            this.vfoB[i].setVisible(true);
        }
        this.disableVFOA();
        this.disableVFOB();
        this.modeLbl.setText("");
        this.modeLbl.setVisible(false);
        this.modeLbl.setLocation(50 + 10 * this.prototypeTextField.getWidth() + 12, 39);
        this.bandLbl.setLocation(50 + 10 * this.prototypeTextField.getWidth() + 12, 19);
        this.bandLbl.setText("");
        this.bandLbl.setVisible(false);
        this.rBtn20.setLocation(50, 115);
        this.rBtn17.setLocation(50 + this.rBtn20.getWidth() + 15, 115);
        this.rBtn15.setLocation(50 + 2 * (this.rBtn20.getWidth() + 15), 115);
        this.rBtn12.setLocation(50 + 3 * (this.rBtn20.getWidth() + 15), 115);
        this.rBtn10.setLocation(50 + 4 * (this.rBtn20.getWidth() + 15), 115);
        this.hideBandButtons();
        this.upBtn.setLocation(388, 60);
        this.dnBtn.setLocation(388, 85);
        this.tuningRateCheckBox.setLocation(380, 115);
        this.vfoALbl.setLocation(35, 17);
        this.vfoBLbl.setLocation(35, 67);
        this.hideTuning();
        this.TxIndicatorTextField.setVisible(false);
        this.TxIndicatorTextField.setLocation(5, 15);
        this.TxIndicatorTextField.setBackground(new Color(0, 153, 0));
        this.splitLbl.setLocation(5, 43);
        this.hideSplit();
        this.setTimeBtn.setLocation(this.rBtn20.getX(), this.rBtn20.getY() + 30);
        this.setTimeBtn.setToolTipText("Copy computer time to QMX");
        this.setTimeBtn.setEnabled(false);
        this.setTimeBtn.setVisible(false);
        this.jLogTextField.setLocation(this.setTimeBtn.getX() + this.setTimeBtn.getWidth(), this.rBtn20.getY() + 30);
        this.jLogTextField.setSize(140, this.jLogTextField.getHeight());
        this.jLogTextField.setVisible(false);
        this.jLogTextField.setToolTipText("Enter text to log");
        this.logBtn.setLocation(this.jLogTextField.getX() + this.jLogTextField.getWidth(), this.rBtn20.getY() + 30);
        this.logBtn.setToolTipText("Add text to log");
        this.logBtn.setEnabled(false);
        this.logBtn.setVisible(false);
        this.sdr2qmxBtn.setLocation(this.logBtn.getX(), this.logBtn.getY() + 27);
        this.sdr2qmxBtn.setToolTipText("Tune QMX to SDR frequency");
        this.sdr2qmxBtn.setEnabled(false);
        this.sdr2qmxBtn.setVisible(false);
        this.comSelectComboBox.requestFocusInWindow();
        this.testButton.setText("SDR++");
        this.testButton.setEnabled(true);
        this.testButton.setText("SDR++");
        this.lastLoggedFreqDT = LocalDateTime.ofEpochSecond(1709596800L, 0, ZoneOffset.UTC);
    }

    private void initComponents() {
        this.BandBtnGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.comSelectComboBox = new JComboBox();
        this.disconnectBtn = new JButton();
        this.connectBtn = new JButton();
        this.comPortLbl = new JLabel();
        this.testButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.debugData = new JTextArea();
        this.prototypeTextField = new JTextField();
        this.prototypeUpDnBtn = new JButton();
        this.mainInterfacePanel = new JPanel();
        this.vfoALbl = new JLabel();
        this.modeLbl = new JLabel();
        this.bandLbl = new JLabel();
        this.upBtn = new JButton();
        this.dnBtn = new JButton();
        this.tuningRateCheckBox = new JCheckBox();
        this.TxIndicatorTextField = new JTextField();
        this.rBtn20 = new JRadioButton();
        this.rBtn17 = new JRadioButton();
        this.rBtn15 = new JRadioButton();
        this.rBtn12 = new JRadioButton();
        this.rBtn10 = new JRadioButton();
        this.vfoBLbl = new JLabel();
        this.splitLbl = new JLabel();
        this.setTimeBtn = new JButton();
        this.jLogTextField = new JTextField();
        this.logBtn = new JButton();
        this.sdr2qmxBtn = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("QMX++");
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setFont(new Font("Courier New", 0, 24));
        this.comSelectComboBox.setName("");
        this.comSelectComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                qmxUI.this.comSelectComboBoxPopupMenuWillBecomeVisible(evt);
            }
        });
        this.disconnectBtn.setText("Disconnect");
        this.disconnectBtn.setName("");
        this.disconnectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.disconnectBtnActionPerformed(evt);
            }
        });
        this.connectBtn.setText("Connect");
        this.connectBtn.setName("");
        this.connectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.connectBtnActionPerformed(evt);
            }
        });
        this.comPortLbl.setText("COM Port:");
        this.testButton.setText("Test");
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.testButtonActionPerformed(evt);
            }
        });
        this.debugData.setEditable(false);
        this.debugData.setColumns(20);
        this.debugData.setFont(new Font("Lucida Console", 0, 12));
        this.debugData.setRows(5);
        this.jScrollPane1.setViewportView(this.debugData);
        this.prototypeTextField.setBackground(new Color(0, 102, 0));
        this.prototypeTextField.setFont(new Font("Courier New", 0, 36));
        this.prototypeTextField.setForeground(new Color(255, 255, 102));
        this.prototypeTextField.setText("0");
        this.prototypeUpDnBtn.setBackground(new Color(102, 0, 0));
        this.prototypeUpDnBtn.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.comPortLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comSelectComboBox, -2, 75, -2).addGap(18, 18, 18).addComponent(this.disconnectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.testButton)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 410, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.prototypeTextField, -2, 33, -2).addGap(18, 18, 18).addComponent(this.prototypeUpDnBtn, -2, 33, -2))))).addGap(14, 14, 14)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.prototypeTextField, -2, 45, -2).addComponent(this.prototypeUpDnBtn, -2, 5, -2)).addGap(18, 18, 18).addComponent(this.jScrollPane1, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.disconnectBtn).addComponent(this.connectBtn).addComponent(this.testButton).addComponent(this.comSelectComboBox, -2, -1, -2).addComponent(this.comPortLbl)).addGap(18, 18, 18)));
        this.mainInterfacePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.vfoALbl.setBackground(new Color(255, 255, 255));
        this.vfoALbl.setFont(new Font("Courier New", 0, 18));
        this.vfoALbl.setForeground(new Color(0, 51, 153));
        this.vfoALbl.setText("A");
        this.vfoALbl.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.vfoALbl.setOpaque(true);
        this.vfoALbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                qmxUI.this.vfoALblMousePressed(evt);
            }
        });
        this.modeLbl.setBackground(new Color(153, 255, 255));
        this.modeLbl.setFont(new Font("Courier New", 1, 12));
        this.modeLbl.setForeground(new Color(0, 51, 153));
        this.modeLbl.setText("digi");
        this.modeLbl.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.bandLbl.setBackground(new Color(153, 255, 255));
        this.bandLbl.setFont(new Font("Courier New", 1, 12));
        this.bandLbl.setForeground(new Color(0, 51, 153));
        this.bandLbl.setText("band");
        this.bandLbl.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.upBtn.setText("\u25b2");
        this.upBtn.setHorizontalTextPosition(0);
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.upBtnActionPerformed(evt);
            }
        });
        this.dnBtn.setText("\u25bc");
        this.dnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.dnBtnActionPerformed(evt);
            }
        });
        this.tuningRateCheckBox.setText("Fast");
        this.TxIndicatorTextField.setEditable(false);
        this.TxIndicatorTextField.setBackground(new Color(153, 0, 0));
        this.TxIndicatorTextField.setFont(new Font("Courier New", 0, 18));
        this.TxIndicatorTextField.setForeground(new Color(255, 255, 204));
        this.TxIndicatorTextField.setHorizontalAlignment(0);
        this.TxIndicatorTextField.setText("R");
        this.BandBtnGroup.add(this.rBtn20);
        this.rBtn20.setText("20");
        this.rBtn20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.rBtn20ActionPerformed(evt);
            }
        });
        this.BandBtnGroup.add(this.rBtn17);
        this.rBtn17.setText("17");
        this.rBtn17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.rBtn17ActionPerformed(evt);
            }
        });
        this.BandBtnGroup.add(this.rBtn15);
        this.rBtn15.setText("15");
        this.rBtn15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.rBtn15ActionPerformed(evt);
            }
        });
        this.BandBtnGroup.add(this.rBtn12);
        this.rBtn12.setText("12");
        this.rBtn12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.rBtn12ActionPerformed(evt);
            }
        });
        this.BandBtnGroup.add(this.rBtn10);
        this.rBtn10.setText("10");
        this.rBtn10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.rBtn10ActionPerformed(evt);
            }
        });
        this.vfoBLbl.setBackground(new Color(255, 255, 255));
        this.vfoBLbl.setFont(new Font("Courier New", 0, 18));
        this.vfoBLbl.setForeground(new Color(0, 51, 153));
        this.vfoBLbl.setText("B");
        this.vfoBLbl.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.vfoBLbl.setOpaque(true);
        this.vfoBLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                qmxUI.this.vfoBLblMousePressed(evt);
            }
        });
        this.splitLbl.setFont(new Font("Segoe UI", 0, 11));
        this.splitLbl.setText("Split Off");
        this.setTimeBtn.setText("Set QMX Time");
        this.setTimeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.setTimeBtnActionPerformed(evt);
            }
        });
        this.logBtn.setText("\u25c4 Log");
        this.logBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.logBtnActionPerformed(evt);
            }
        });
        this.sdr2qmxBtn.setText("SDR\u2192QMX");
        this.sdr2qmxBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                qmxUI.this.sdr2qmxBtnActionPerformed(evt);
            }
        });
        GroupLayout mainInterfacePanelLayout = new GroupLayout(this.mainInterfacePanel);
        this.mainInterfacePanel.setLayout(mainInterfacePanelLayout);
        mainInterfacePanelLayout.setHorizontalGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainInterfacePanelLayout.createSequentialGroup().addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainInterfacePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.splitLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bandLbl, -2, 32, -2)).addGroup(mainInterfacePanelLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.vfoALbl, -2, 14, -2).addComponent(this.TxIndicatorTextField, -2, 25, -2)).addGap(29, 29, 29).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainInterfacePanelLayout.createSequentialGroup().addComponent(this.rBtn20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rBtn17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rBtn15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rBtn12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rBtn10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addComponent(this.tuningRateCheckBox).addGap(18, 18, 18).addComponent(this.upBtn).addGap(8, 8, 8).addComponent(this.dnBtn).addGap(18, 18, 18).addComponent(this.modeLbl)).addGroup(mainInterfacePanelLayout.createSequentialGroup().addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vfoBLbl, -2, 14, -2).addGroup(mainInterfacePanelLayout.createSequentialGroup().addComponent(this.setTimeBtn).addGap(18, 18, 18).addComponent(this.jLogTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.logBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sdr2qmxBtn))).addGap(0, 0, Short.MAX_VALUE))))).addGap(15, 15, 15)));
        mainInterfacePanelLayout.setVerticalGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainInterfacePanelLayout.createSequentialGroup().addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainInterfacePanelLayout.createSequentialGroup().addGap(14, 14, 14).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vfoALbl, -2, 18, -2).addComponent(this.vfoBLbl, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.splitLbl)).addGroup(GroupLayout.Alignment.TRAILING, mainInterfacePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.bandLbl, -2, 14, -2))).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainInterfacePanelLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upBtn).addComponent(this.dnBtn).addComponent(this.tuningRateCheckBox).addComponent(this.TxIndicatorTextField, -2, 22, -2))).addGroup(mainInterfacePanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rBtn12).addComponent(this.rBtn10).addComponent(this.rBtn15).addComponent(this.rBtn17).addComponent(this.rBtn20)).addComponent(this.modeLbl, -2, 14, -2)))).addGap(18, 18, 18).addGroup(mainInterfacePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setTimeBtn).addComponent(this.jLogTextField, -2, -1, -2).addComponent(this.logBtn).addComponent(this.sdr2qmxBtn)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainInterfacePanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap(25, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.mainInterfacePanel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addGap(25, 25, 25)));
        this.jPanel1.getAccessibleContext().setAccessibleName("");
        this.mainInterfacePanel.getAccessibleContext().setAccessibleName("");
        this.mainInterfacePanel.getAccessibleContext().setAccessibleDescription("");
        this.pack();
    }

    private void comSelectComboBoxPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        SerialPort[] portLists;
        this.comSelectComboBox.removeAllItems();
        for (SerialPort port : portLists = SerialPort.getCommPorts()) {
            this.comSelectComboBox.addItem(port.getSystemPortName());
        }
    }

    private void connectBtnActionPerformed(ActionEvent evt) {
        block10: {
            if (this.debugFileEnabled) {
                try {
                    debugFileWriter = new FileWriter(this.debugFilePath + this.debugFileName, true);
                    this.debugPrint = new PrintWriter(debugFileWriter);
                }
                catch (IOException e) {
                    this.debugFileEnabled = false;
                }
            }
            try {
                SerialPort[] portLists = SerialPort.getCommPorts();
                this.qmxPort = portLists[this.comSelectComboBox.getSelectedIndex()];
                this.qmxPort.setBaudRate(9600);
                this.qmxPort.setNumDataBits(this.DATABITS);
                this.qmxPort.setNumStopBits(this.STOPBITS);
                this.qmxPort.setParity(this.NO_PARITY);
                this.qmxPort.openPort();
                if (this.qmxPort.isOpen()) {
                    if (enableLog) {
                        try {
                            this.logFileWriter = new FileWriter(this.logFilePath + this.logFileName, true);
                            this.logFileBufferedWriter = new BufferedWriter(this.logFileWriter);
                            this.logActive = true;
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(this, "Cannot open debug file!");
                            this.logActive = false;
                        }
                    }
                    this.logActivity("Connected to QMX");
                    this.connectBtn.setEnabled(false);
                    this.comSelectComboBox.setEnabled(false);
                    this.disconnectBtn.setEnabled(true);
                    this.enableVFOA();
                    this.enableVFOB();
                    this.modeLbl.setVisible(true);
                    this.bandLbl.setVisible(true);
                    this.showBandButtons();
                    this.CAT_update_timer.start();
                    this.Serial_EventBasedRead(this.qmxPort);
                    this.testButton.enableInputMethods(true);
                    this.TxIndicatorTextField.setVisible(true);
                    this.lastVFOA = "00000000000";
                    this.lastVFOB = "00000000000";
                    this.catMsgNdx = 0;
                    this.selectVFOA();
                    this.setTimeBtn.setEnabled(true);
                    this.setTimeBtn.setVisible(true);
                    this.jLogTextField.setVisible(true);
                    this.logBtn.setEnabled(true);
                    this.logBtn.setVisible(true);
                    break block10;
                }
                JOptionPane.showMessageDialog(this, this.qmxPort.getDescriptivePortName() + " connect failed!");
            }
            catch (ArrayIndexOutOfBoundsException a) {
                JOptionPane.showMessageDialog(this, "Please choose valid COM port!", "ERROR", 0);
            }
            catch (Exception b) {
                JOptionPane.showMessageDialog(this, b, "ERROR", 0);
            }
        }
    }

    private void disconnectBtnActionPerformed(ActionEvent evt) {
        if (this.qmxPort.isOpen()) {
            this.qmxPort.closePort();
            this.connectBtn.setEnabled(true);
            this.disconnectBtn.setEnabled(false);
            this.comSelectComboBox.setEnabled(true);
            this.debugData.setText("");
            this.disableVFOA();
            this.disableVFOB();
            this.modeLbl.setVisible(false);
            this.bandLbl.setVisible(false);
            this.CAT_update_timer.stop();
            this.hideTuning();
            this.hideBandButtons();
            this.testButton.enableInputMethods(false);
            this.TxIndicatorTextField.setVisible(false);
            this.logActivity("Disconnected from QMX");
            this.setTimeBtn.setEnabled(false);
            this.setTimeBtn.setVisible(false);
            this.jLogTextField.setVisible(false);
            this.logBtn.setEnabled(false);
            this.logBtn.setVisible(false);
            if (this.logActive) {
                try {
                    this.logFileBufferedWriter.close();
                    this.logActive = false;
                }
                catch (IOException e) {
                    this.logActive = false;
                }
            }
        }
        if (this.debugFileEnabled) {
            this.debugPrint.close();
        }
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        this.toggleRigctlEnabled();
    }

    private void upBtnActionPerformed(ActionEvent evt) {
        String s = this.lastVFOA;
        if (this.targetVFO == 1) {
            s = this.lastVFOB;
        }
        int iFreq = Integer.parseInt(s);
        iFreq = this.tuningRateCheckBox.isSelected() ? (iFreq += this.fastHz) : (iFreq += this.slowHz);
        s = this.sFrequency(iFreq);
        if (this.targetVFO == 0) {
            this.updateVFOA(s);
            this.sendCAT("FA" + s + ';');
        } else if (this.targetVFO == 1) {
            this.updateVFOB(s);
            this.sendCAT("FB" + s + ';');
        }
    }

    private void dnBtnActionPerformed(ActionEvent evt) {
        String s = this.lastVFOA;
        if (this.targetVFO == 1) {
            s = this.lastVFOB;
        }
        int iFreq = Integer.valueOf(s);
        iFreq = this.tuningRateCheckBox.isSelected() ? (iFreq -= this.fastHz) : (iFreq -= this.slowHz);
        s = this.sFrequency(iFreq);
        if (this.targetVFO == 0) {
            this.updateVFOA(s);
            this.sendCAT("FA" + s + ';');
        } else if (this.targetVFO == 1) {
            this.updateVFOB(s);
            this.sendCAT("FB" + s + ';');
        }
    }

    private void rBtn20ActionPerformed(ActionEvent evt) {
        this.sendOnce = "FA" + this.bS20A + ';' + "FB" + this.bS20B + ';';
        this.logActivity("20 meter band selected");
    }

    private void rBtn17ActionPerformed(ActionEvent evt) {
        this.sendOnce = "FA" + this.bS17A + ';' + "FB" + this.bS17B + ';';
        this.logActivity("17 meter band selected");
    }

    private void rBtn15ActionPerformed(ActionEvent evt) {
        this.sendOnce = "FA" + this.bS15A + ';' + "FB" + this.bS15B + ';';
        this.logActivity("15 meter band selected");
    }

    private void rBtn12ActionPerformed(ActionEvent evt) {
        this.sendOnce = "FA" + this.bS12A + ';' + "FB" + this.bS12B + ';';
        this.logActivity("12 meter band selected");
    }

    private void rBtn10ActionPerformed(ActionEvent evt) {
        this.sendOnce = "FA" + this.bS10A + ';' + "FB" + this.bS10B + ';';
        this.logActivity("10 meter band selected");
    }

    private void vfoALblMousePressed(MouseEvent evt) {
        this.sendOnce = "FR0;";
        this.logActivity("VFO-A selected");
    }

    private void vfoBLblMousePressed(MouseEvent evt) {
        this.sendOnce = "FR1;";
        this.logActivity("VFO-B selected");
    }

    private void setTimeBtnActionPerformed(ActionEvent evt) {
        this.sendOnce = "TM" + this.sTime() + ';';
        this.setTimeBtn.setText("QMX time set");
        this.setTimeBtn.setEnabled(false);
    }

    private void logBtnActionPerformed(ActionEvent evt) {
        if (this.jLogTextField.getText().length() > 0) {
            if (contactLog) {
                this.logContact(this.jLogTextField.getText());
                this.jLogTextField.requestFocusInWindow();
            } else {
                this.logActivity(this.jLogTextField.getText());
            }
        }
        this.jLogTextField.setText("");
    }

    private void sdr2qmxBtnActionPerformed(ActionEvent evt) {
        if (this.rigctlEnabled && this.rigctlVFO > 0) {
            String s = Integer.toString(this.rigctlVFO);
            while (s.length() < 11) {
                s = "0" + s;
            }
            this.sendOnce = "FA" + s + ';';
        }
    }

    private void Serial_EventBasedRead(SerialPort activePort) {
        activePort.addDataListener(new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                return 16;
            }

            @Override
            public void serialEvent(SerialPortEvent event) {
                StringBuilder sb = new StringBuilder();
                byte[] newData = event.getReceivedData();
                for (int i = 0; i < newData.length; ++i) {
                    char c = (char)newData[i];
                    sb.append(c);
                }
                qmxUI.this.sCommand = qmxUI.this.sCommand.concat(sb.toString());
                while (qmxUI.this.sCommand.indexOf(59) >= 0) {
                    int ndxEOC = qmxUI.this.sCommand.indexOf(59) + 1;
                    qmxUI.this.processCAT(qmxUI.this.sCommand.substring(0, ndxEOC));
                    qmxUI.this.sCommand = qmxUI.this.sCommand.substring(ndxEOC);
                }
            }
        });
    }

    private void sendCAT(String s) {
        this.txStream = this.qmxPort.getOutputStream();
        try {
            this.txStream.write(s.getBytes("ASCII"));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void processCAT(String sCommand) {
        if ((sCommand = sCommand.toUpperCase()).charAt(0) == '?') {
            return;
        }
        String cc = sCommand.substring(0, 2);
        if (cc.equals("FA")) {
            if (sCommand.charAt(2) != ';' && sCommand.charAt(13) == ';') {
                this.updateVFOA(sCommand.substring(2, 13));
            }
        } else if (cc.equals("FB")) {
            if (sCommand.charAt(2) != ';' && sCommand.charAt(13) == ';') {
                this.updateVFOB(sCommand.substring(2, 13));
            }
        } else if (cc.equals("FR")) {
            if (sCommand.charAt(2) == '1') {
                this.rxVFO = 1;
                this.selectVFOB();
                if (this.rxVFO != this.lastRxVFO) {
                    this.logActivity("VFO-B selected");
                    this.logAssociatedFrequency();
                    this.lastRxVFO = this.rxVFO;
                }
            } else {
                this.rxVFO = 0;
                this.selectVFOA();
                if (this.rxVFO != this.lastRxVFO) {
                    this.logActivity("VFO-A selected");
                    this.logAssociatedFrequency();
                    this.lastRxVFO = this.rxVFO;
                }
            }
            this.targetVFO = this.rxVFO;
        } else if (cc.equals("FT")) {
            this.txVFO = sCommand.charAt(2) == '1' ? 1 : 0;
        } else if (!cc.equals("FW") && !cc.equals("ID")) {
            if (cc.equals("IF")) {
                if (sCommand.charAt(2) != ';' && sCommand.charAt(36) == ';') {
                    this.updateVFOA(sCommand.substring(2, 13));
                    this.sRIT = sCommand.substring(18, 23);
                    this.ritStatus = sCommand.charAt(23) == '1';
                    this.xcvrStatus = sCommand.charAt(28) == '\u0001' ? 1 : 0;
                    this.operMode = sCommand.charAt(29) - 48;
                    this.rcvVFO = sCommand.charAt(30) - 48;
                    this.simplex = sCommand.charAt(32) == '\u0000';
                }
            } else if (cc.equals("MD")) {
                this.cOperMode = sCommand.charAt(2);
                if (this.cOperMode == '3') {
                    this.modeLbl.setText(" cw");
                    if (this.cOperMode != this.lastOperMode) {
                        this.logActivity("Receive mode CW");
                        this.logAssociatedFrequency();
                        this.lastOperMode = (char)51;
                    }
                } else if (this.cOperMode == '6') {
                    this.modeLbl.setText("digi");
                    if (this.cOperMode != this.lastOperMode) {
                        this.logActivity("Receive mode digi");
                        this.logAssociatedFrequency();
                        this.lastOperMode = (char)54;
                    }
                }
            } else if (!(cc.equals("Q0") || cc.equals("Q1") || cc.equals("Q2") || cc.equals("Q3") || cc.equals("Q4") || cc.equals("Q5") || cc.equals("Q6") || cc.equals("Q7") || cc.equals("Q8") || cc.equals("Q9") || cc.equals("QA") || cc.equals("QB") || cc.equals("QC") || cc.equals("QJ") || cc.equals("RD") || cc.equals("RT") || cc.equals("RU") || cc.equals("RX"))) {
                if (cc.equals("SP")) {
                    this.splitVFO = sCommand.charAt(2) == '1';
                    this.showSplit();
                    if (this.splitVFO != this.lastLoggedSplitVFO) {
                        if (this.splitVFO) {
                            this.logActivity("Split VFO enabled");
                        } else {
                            this.logActivity("Split VFO disabled");
                        }
                        this.logAssociatedFrequency();
                        this.lastLoggedSplitVFO = this.splitVFO;
                    }
                } else if (cc.equals("TQ")) {
                    if (sCommand.charAt(2) == '1') {
                        this.denoteTx();
                    } else {
                        this.denoteRx();
                    }
                } else if (cc.equals("TX") || cc.equals("VN")) {
                    // empty if block
                }
            }
        }
        this.splitVFO = this.rxVFO != this.txVFO;
    }

    private void disableVFOA() {
        for (int i = 0; i < 10; ++i) {
            this.vfoA[i].setText("");
            this.vfoA[i].setEnabled(false);
            this.vfoALbl.setText("");
            this.vfoALbl.setVisible(false);
        }
    }

    private void enableVFOA() {
        for (int i = 0; i < 10; ++i) {
            this.vfoA[i].setEnabled(true);
        }
        this.vfoA[2].setText(DLM);
        this.vfoA[6].setText(DLM);
        this.vfoALbl.setVisible(true);
    }

    private void disableVFOB() {
        for (int i = 0; i < 10; ++i) {
            this.vfoB[i].setText("");
            this.vfoB[i].setEnabled(false);
            this.vfoBLbl.setText("");
            this.vfoBLbl.setVisible(false);
        }
    }

    private void enableVFOB() {
        for (int i = 0; i < 10; ++i) {
            this.vfoB[i].setEnabled(true);
        }
        this.vfoB[2].setText(DLM);
        this.vfoB[6].setText(DLM);
        this.vfoBLbl.setVisible(true);
    }

    private void hideTuning() {
        this.upBtn.setVisible(false);
        this.dnBtn.setVisible(false);
        this.tuningRateCheckBox.setVisible(false);
        this.hideSplit();
    }

    private void showTuning() {
        if (this.TxMode) {
            return;
        }
        this.upBtn.setVisible(true);
        this.dnBtn.setVisible(true);
        this.tuningRateCheckBox.setVisible(true);
        this.showSplit();
    }

    private void hideSplit() {
        this.splitLbl.setVisible(false);
    }

    private void showSplit() {
        if (this.splitVFO) {
            this.splitLbl.setText("Split On");
        } else {
            this.splitLbl.setText("Split Off");
        }
        this.splitLbl.setVisible(true);
    }

    private void selectVFOA() {
        this.vfoBLbl.setBackground(new Color(255, 255, 255));
        this.vfoALbl.setBackground(this.tuneableVFOlabelColor);
    }

    private void selectVFOB() {
        this.vfoALbl.setBackground(new Color(255, 255, 255));
        this.vfoBLbl.setBackground(this.tuneableVFOlabelColor);
    }

    private void hideBandButtons() {
        this.rBtn20.setVisible(false);
        this.rBtn17.setVisible(false);
        this.rBtn15.setVisible(false);
        this.rBtn12.setVisible(false);
        this.rBtn10.setVisible(false);
        this.currentBandNdx = -1;
        this.previousBandNdx = -1;
    }

    private void showBandButtons() {
        this.rBtn20.setVisible(true);
        this.rBtn17.setVisible(true);
        this.rBtn15.setVisible(true);
        this.rBtn12.setVisible(true);
        this.rBtn10.setVisible(true);
        this.currentBandNdx = -1;
        this.previousBandNdx = -1;
    }

    private void updateVFOA(String catFrequency) {
        String s = catFrequency.substring(3, 11);
        if (s.equals(this.lastVFOA)) {
            return;
        }
        this.lastVFOA = s;
        this.vfoA[0].setText(s.substring(0, 1));
        this.vfoA[1].setText(s.substring(1, 2));
        this.vfoA[3].setText(s.substring(2, 3));
        this.vfoA[4].setText(s.substring(3, 4));
        this.vfoA[5].setText(s.substring(4, 5));
        this.vfoA[7].setText(s.substring(5, 6));
        this.vfoA[8].setText(s.substring(6, 7));
        this.vfoA[9].setText(s.substring(7, 8));
        this.vfoALbl.setText("A");
        this.bandLbl.setText(" " + this.sBand(s));
        this.setSelectedRadioGroupBand();
        this.updateVfoABandChangeFrequency(catFrequency);
        this.showTuning();
        this.sendFrequencyToRigctl(this.lastVFOA);
        this.logTuning();
    }

    private void updateVFOB(String catFrequency) {
        String s = catFrequency.substring(3, 11);
        if (s.equals(this.lastVFOB)) {
            return;
        }
        this.lastVFOB = s;
        this.vfoB[0].setText(s.substring(0, 1));
        this.vfoB[1].setText(s.substring(1, 2));
        this.vfoB[3].setText(s.substring(2, 3));
        this.vfoB[4].setText(s.substring(3, 4));
        this.vfoB[5].setText(s.substring(4, 5));
        this.vfoB[7].setText(s.substring(5, 6));
        this.vfoB[8].setText(s.substring(6, 7));
        this.vfoB[9].setText(s.substring(7, 8));
        this.vfoBLbl.setText("B");
        this.bandLbl.setText(" " + this.sBand(s));
        this.setSelectedRadioGroupBand();
        this.updateVfoBBandChangeFrequency(catFrequency);
        this.showTuning();
        this.logTuning();
    }

    private void logTuning() {
        if (verboseLogTuning) {
            LocalDateTime dt = LocalDateTime.now();
            if (ChronoUnit.SECONDS.between(this.lastLoggedFreqDT, dt) < 1L) {
                return;
            }
            if (this.targetVFO == 0) {
                this.logActivity("VFO-A tuned to " + this.lastVFOA + " Hz");
                this.lastLoggedFreqDT = dt;
            } else if (this.targetVFO == 1) {
                this.logActivity("VFO-B tuned to " + this.lastVFOB + " Hz");
                this.lastLoggedFreqDT = dt;
            }
        }
    }

    private void logAssociatedFrequency() {
        if (verboseLogTuning) {
            return;
        }
        LocalDateTime dt = LocalDateTime.now();
        if (this.splitVFO) {
            if (this.lastVFOA.equals(this.lastVFOB)) {
                this.logActivity("VFO's tuned to " + this.lastVFOA + " Hz");
            } else {
                this.logActivity("VFO-A tuned to " + this.lastVFOA + " Hz");
                this.logActivity("VFO-B tuned to " + this.lastVFOB + " Hz");
            }
        } else if (this.targetVFO == 0) {
            this.logActivity("VFO-A tuned to " + this.lastVFOA + " Hz");
        } else if (this.targetVFO == 1) {
            this.logActivity("VFO-B tuned to " + this.lastVFOB + " Hz");
        }
        this.lastLoggedFreqDT = dt;
    }

    private void updateVfoABandChangeFrequency(String catFreq) {
        if (this.currentBandNdx == 0) {
            this.bS20A = catFreq;
        } else if (this.currentBandNdx == 1) {
            this.bS17A = catFreq;
        } else if (this.currentBandNdx == 2) {
            this.bS15A = catFreq;
        } else if (this.currentBandNdx == 3) {
            this.bS12A = catFreq;
        } else if (this.currentBandNdx == 4) {
            this.bS10A = catFreq;
        }
        if (this.currentBandNdx != this.previousBandNdx) {
            if (this.currentBandNdx == 0) {
                this.logActivity("20 meter band selected");
            } else if (this.currentBandNdx == 1) {
                this.logActivity("17 meter band selected");
            } else if (this.currentBandNdx == 2) {
                this.logActivity("15 meter band selected");
            } else if (this.currentBandNdx == 3) {
                this.logActivity("12 meter band selected");
            } else if (this.currentBandNdx == 4) {
                this.logActivity("10 meter band selected");
            }
            if (!verboseLogTuning) {
                this.logActivity("VFO-A " + catFreq + " Hz");
            }
            this.previousBandNdx = this.currentBandNdx;
        }
    }

    private void updateVfoBBandChangeFrequency(String catFreq) {
        if (this.currentBandNdx == 0) {
            this.bS20B = catFreq;
        } else if (this.currentBandNdx == 1) {
            this.bS17B = catFreq;
        } else if (this.currentBandNdx == 2) {
            this.bS15B = catFreq;
        } else if (this.currentBandNdx == 3) {
            this.bS12B = catFreq;
        } else if (this.currentBandNdx == 4) {
            this.bS10B = catFreq;
        }
    }

    private void denoteTx() {
        this.TxMode = true;
        this.TxIndicatorTextField.setBackground(new Color(153, 0, 0));
        this.TxIndicatorTextField.setText("T");
        if (!this.lastLoggedTxMode) {
            this.logActivity("Start transmit");
            this.logAssociatedFrequency();
        }
        this.lastLoggedTxMode = true;
        this.lastRxTxTransitionDT = LocalDateTime.now();
    }

    private void denoteRx() {
        long delta;
        this.TxMode = false;
        this.TxIndicatorTextField.setBackground(new Color(0, 153, 0));
        this.TxIndicatorTextField.setText("R");
        if (this.lastLoggedTxMode && (delta = ChronoUnit.SECONDS.between(this.lastRxTxTransitionDT, LocalDateTime.now())) > 5L) {
            this.logActivity(this.lastRxTxTransitionDT, "End transmit");
            this.lastLoggedTxMode = false;
        }
    }

    private int band(String sF) {
        int freq = Integer.valueOf(sF.substring(0, 5));
        if (freq <= 29700 && freq >= 14000) {
            if (freq >= 28000) {
                this.currentBandNdx = 4;
                return 10;
            }
            if (freq <= 24990) {
                if (freq >= 24890) {
                    this.currentBandNdx = 3;
                    return 12;
                }
                if (freq >= 21000) {
                    this.currentBandNdx = 2;
                    return 15;
                }
                if (freq >= 18068) {
                    this.currentBandNdx = 1;
                    return 17;
                }
                if (freq >= 14000) {
                    this.currentBandNdx = 0;
                    return 20;
                }
            } else {
                this.currentBandNdx = -1;
                return -1;
            }
        }
        return -1;
    }

    private String sBand(String sF) {
        int freq = Integer.valueOf(sF.substring(0, 5));
        if (freq <= 29700 && freq >= 14000) {
            if (freq >= 28000) {
                this.currentBandNdx = 4;
                return "10";
            }
            if (freq <= 24990) {
                if (freq >= 24890) {
                    this.currentBandNdx = 3;
                    return "12";
                }
                if (freq >= 21000) {
                    this.currentBandNdx = 2;
                    return "15";
                }
                if (freq >= 18068) {
                    this.currentBandNdx = 1;
                    return "17";
                }
                if (freq >= 14000) {
                    this.currentBandNdx = 0;
                    return "20";
                }
            } else {
                this.currentBandNdx = -1;
                return "  ";
            }
        }
        return "  ";
    }

    private void setSelectedRadioGroupBand() {
        if (this.currentBandNdx == 0) {
            this.rBtn20.setSelected(true);
        } else if (this.currentBandNdx == 1) {
            this.rBtn17.setSelected(true);
        } else if (this.currentBandNdx == 2) {
            this.rBtn15.setSelected(true);
        } else if (this.currentBandNdx == 3) {
            this.rBtn12.setSelected(true);
        } else if (this.currentBandNdx == 4) {
            this.rBtn10.setSelected(true);
        }
    }

    private String sFrequency(int iFreq) {
        String s = Integer.toString(iFreq);
        while (s.length() < 11) {
            s = "0" + s;
        }
        return s;
    }

    private String sTime() {
        String s = LocalDateTime.now().toString();
        return s.substring(11, 13) + s.substring(14, 16) + s.substring(17, 19);
    }

    private void logActivity(String sData) {
        if (this.logActive && !contactLog) {
            this.logDT = LocalDateTime.now();
            try {
                this.logFileBufferedWriter.write(this.logDT.toString());
                this.logFileBufferedWriter.write(9);
                this.logFileBufferedWriter.write(sData);
                this.logFileBufferedWriter.newLine();
                this.lastLogDT = this.logDT;
            }
            catch (IOException e) {
                this.logActive = false;
            }
        }
    }

    private void logActivity(LocalDateTime atTime, String sData) {
        if (this.logActive && !contactLog) {
            try {
                this.logFileBufferedWriter.write(9);
                this.logFileBufferedWriter.write(atTime.toString());
                this.logFileBufferedWriter.write(9);
                this.logFileBufferedWriter.write(sData);
                this.logFileBufferedWriter.newLine();
                this.lastLogDT = LocalDateTime.now();
            }
            catch (IOException e) {
                this.logActive = false;
            }
        }
    }

    private void logContact(String callsign) {
        if (!this.logActive) {
            return;
        }
        String sDT = LocalDateTime.now(ZoneOffset.UTC).toString();
        String ymd = sDT.substring(0, 10);
        String t24 = sDT.substring(11, 16);
        String logEntry = callsign + '\t';
        String sF = "";
        logEntry = logEntry + ymd + '\t' + t24 + '\t';
        if (this.txVFO == 0) {
            sF = this.lastVFOA;
        } else if (this.txVFO == 1) {
            sF = this.lastVFOB;
        }
        String sB = this.sBand(sF);
        sF = sF.substring(0, 2) + "," + sF.substring(2, 5) + DLM + sF.substring(5, 6);
        logEntry = logEntry + sB + "m" + '\t';
        logEntry = logEntry + "" + sF + "kHz" + '\t';
        if (this.lastOperMode == '3') {
            logEntry = logEntry + "CW" + '\t' + "599 599" + '\t';
        } else if (this.lastOperMode == '6') {
            logEntry = logEntry + "Digital" + '\t';
        }
        try {
            this.logFileBufferedWriter.write(logEntry);
            this.logFileBufferedWriter.newLine();
            this.lastLogDT = LocalDateTime.now();
        }
        catch (IOException e) {
            this.logActive = false;
        }
    }

    private void printDebugData(String sData) {
        if (this.debugFileEnabled) {
            this.debugPrint.print(LocalDateTime.now().toString() + '\t');
            this.debugPrint.println(sData);
        }
    }

    private void toggleRigctlEnabled() {
        if (this.rigctlEnabled) {
            this.rigctlEnabled = false;
            this.testButton.setBackground(new Color(255, 255, 255));
            this.sdr2qmxBtn.setEnabled(false);
            this.sdr2qmxBtn.setVisible(false);
        } else {
            this.rigctlEnabled = true;
            this.testButton.setBackground(new Color(0, 153, 0));
            this.sdr2qmxBtn.setEnabled(true);
            this.sdr2qmxBtn.setVisible(true);
        }
    }

    private void sendToRigctl(String cmd) {
        if (this.rigctlEnabled) {
            try (Socket rcSocket = new Socket(this.rigctlHost, this.rigctlPort);){
                this.rcOutput = rcSocket.getOutputStream();
                this.rcWriter = new PrintWriter(this.rcOutput, true);
                this.rcWriter.println(cmd);
                this.rcWriter.close();
                rcSocket.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Rig control connect failed!");
                this.rigctlEnabled = false;
            }
        }
    }

    private void sendFrequencyToRigctl(String freq) {
        this.rigctlVFO = Integer.parseInt(freq);
        this.sendToRigctl("F " + Integer.toString(this.rigctlVFO + this.freqCorrection));
    }

    private String newGetRigctlFrequency() {
        String s = "";
        int cCount = 8;
        char[] msg = new char[8];
        int toMS = 10;
        try (Socket rcSocket = new Socket(this.rigctlHost, this.rigctlPort);){
            rcSocket.setSoTimeout(10);
            this.rcOutput = rcSocket.getOutputStream();
            this.rcWriter = new PrintWriter(this.rcOutput, true);
            this.rcWriter.println("f");
            this.rcInput = rcSocket.getInputStream();
            this.rcReader = new BufferedReader(new InputStreamReader(this.rcInput));
            this.rcReader.read(msg);
            for (int i = 0; i < 8; ++i) {
                s = s + msg[i];
            }
            this.rcReader.close();
        }
        catch (SocketTimeoutException to) {
            s = "time-out";
        }
        catch (IOException ex) {
            this.testButton.setBackground(new Color(255, 255, 255));
            JOptionPane.showMessageDialog(this, "Rig control connect failed!");
            this.rigctlEnabled = false;
        }
        return s;
    }

    private void processFrequencyFromRigctl(String s) {
        int iFreq = Integer.parseInt(s);
        if (iFreq == this.rigctlVFO) {
            return;
        }
        this.rigctlVFO = iFreq;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-L")) {
                enableLog = true;
                continue;
            }
            if (args[i].equals("-V")) {
                verboseLogTuning = true;
                continue;
            }
            if (!args[i].equals("-W")) continue;
            contactLog = true;
        }
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(qmxUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(qmxUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(qmxUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(qmxUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new qmxUI().setVisible(true);
            }
        });
    }

    String randomTestFrequency() {
        Random x = new Random();
        return Integer.toString(14060000 + x.nextInt(10000) - 1);
    }
}

